class X2Effect_Reave extends X2Effect_ModifyStats;

var float BaseShieldHPIncrease; //2
var float ReaveShieldHPDivisor; // 50, so 100 psi offense = 2 extra points
var float AmpMGShieldHPBonus; //2
var float AmpBMShieldHPBonus; //4
var bool IsMinorReave;

//minor reave is 1, 50, 0, 0 
protected simulated function OnEffectAdded(const out EffectAppliedData ApplyEffectParameters, XComGameState_BaseObject kNewTargetState, XComGameState NewGameState, XComGameState_Effect NewEffectState)
{
	local StatChange			ShieldHPChange;
	local XComGameState_Unit	Caster;
	local XComGameState_Item	SourceItem;

	ShieldHPChange.StatType = eStat_ShieldHP;

	Caster = XComGameState_Unit (NewGameState.GetGameStateForObjectID(ApplyEffectParameters.SourceStateObjectRef.ObjectID));
    if(Caster == none)
    {
        Caster = XComGameState_Unit(class'XComGameStateHistory'.static.GetGameStateHistory().GetGameStateForObjectID(ApplyEffectParameters.SourceStateObjectRef.ObjectID));
    }
	SourceItem = XComGameState_Item(NewGameState.GetGameStateForObjectID(ApplyEffectParameters.ItemStateObjectRef.ObjectID));
	if(SourceItem == none)
    {
        SourceItem = XComGameState_Item(class'XComGameStateHistory'.static.GetGameStateHistory().GetGameStateForObjectID(ApplyEffectParameters.ItemStateObjectRef.ObjectID));
    }
	

	if(!IsMinorReave)
	{
		ShieldHPChange.StatAmount = BaseShieldHPIncrease + (Caster.GetCurrentStat(eStat_PsiOffense) / ReaveShieldHPDivisor);

		if (SourceItem != none && SourceItem.GetMyTemplateName() == 'RM_BioticAmp_MG')
		{
			ShieldHPChange.StatAmount += AmpMGShieldHPBonus;
		}
		if (SourceItem != none && SourceItem.GetMyTemplateName() == 'RM_BioticAmp_BM')
		{
			ShieldHPChange.StatAmount += AmpBMShieldHPBonus;
		}
	}

	if(IsMinorReave)
	{
		ShieldHPChange.StatAmount = BaseShieldHPIncrease;
	}

	if(Caster.GetCurrentStat(eStat_ShieldHP) >= 12) //past a point, they can't get any more
	{
		ShieldHPChange.StatAmount = 0;
	}
		
	NewEffectState.StatChanges.AddItem(ShieldHPChange);

	super.OnEffectAdded(ApplyEffectParameters, kNewTargetState, NewGameState, NewEffectState);
}
